/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.vecmath.Vector2f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class DownloadThread
extends Thread {
    public static HashMap<String, Integer> loadedImages = new HashMap();
    public static HashMap<String, Vector2f> loadedImagesSize = new HashMap();
    public static ArrayList<String> loadingImages = new ArrayList();
    private String url;
    private float progress = 0.0f;
    private BufferedImage loadedImage = null;
    private static final int BYTES_PER_PIXEL = 4;

    public DownloadThread(String url) {
        this.url = url;
        this.start();
    }

    public boolean hasFinished() {
        return this.progress == 1.0f;
    }

    public boolean hasFailed() {
        return this.hasFinished() && this.loadedImage == null;
    }

    public BufferedImage getDownloadedImage() {
        return this.loadedImage;
    }

    public float getProgress() {
        return this.progress;
    }

    @Override
    public void run() {
        try {
            this.loadedImage = ImageIO.read(new URL(this.url));
        }
        catch (Exception e) {
            this.loadedImage = null;
            e.printStackTrace();
        }
        this.progress = 1.0f;
    }

    public static int loadImage(DownloadThread thread) {
        if (!thread.hasFailed()) {
            BufferedImage image = thread.getDownloadedImage();
            int id = DownloadThread.loadTexture(image);
            loadedImages.put(thread.url, id);
            loadedImagesSize.put(thread.url, new Vector2f((float)image.getWidth(), (float)image.getHeight()));
            return id;
        }
        return -1;
    }

    public static int loadTexture(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = pixels[y * image.getWidth() + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        return textureID;
    }
}

